<?php
/**
 * @package         NoNumber Framework
 * @version         16.1.24081
 * 
 * @author          Peter van Westen <peter@nonumber.nl>
 * @link            http://www.nonumber.nl
 * @copyright       Copyright © 2016 NoNumber All Rights Reserved
 * @license         http://www.gnu.org/licenses/gpl-2.0.html GNU/GPL
 */

defined('_JEXEC') or die;

require_once dirname(__DIR__) . '/helpers/field.php';

class JFormFieldNN_License extends NNFormField
{
	public $type = 'License';

	protected function getLabel()
	{
		return '';
	}

	protected function getInput()
	{
		$this->params = $this->element->attributes();

		$extension = $this->get('extension');

		if (!strlen($extension))
		{
			return '';
		}

		require_once dirname(__DIR__) . '/helpers/licenses.php';

		return '</div><div class="hide">' . NoNumberLicenses::render($extension, true);
	}
}
